/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: NewAndDeleteDrv98.cpp,v 1.3 1999/09/23 23:50:55 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "pgpMemoryMgr.h"

_USING_PGP

// Operator new and delete helper functions

void * 
NewAndDelete::NewHelper(size_t size, MemoryType memType, PGPBoolean throws)
{
	pgpAssert(!throws);

	if (size == 0)
		size = 1;	// required by standard!

	void	*pMem	= _HeapAllocate(size, 0);

#if PGP_DEBUG
	if (IsntNull(pMem))
		pgpDebugWhackMemory(pMem, size);
#endif	// PGP_DEBUG

	return pMem;
};

void 
NewAndDelete::DeleteHelper(void *p)
{
	if (IsntNull(p))
		_HeapFree(p, 0);
}
